#include "Arduino_LSM6DS3.h"

bool ledState = LOW,
      whiteLEDState = LOW,
      blueLEDState = LOW;
#define whiteLED 2
#define blueLED 3 

void setup() {
  Serial.begin(9600);
  // attempt to start the IMU:
  if (!IMU.begin()) {
    Serial.println("Failed to initialize IMU");
    // stop here if you can't access the IMU:
    while (true)
      ;
  }
  pinMode(LED_BUILTIN, OUTPUT);
  pinMode(whiteLED, OUTPUT);
  pinMode(blueLED, OUTPUT);
  digitalWrite(LED_BUILTIN, ledState);
  while (Serial.available() <= 0) {
    Serial.println("hello"); // send a starting message
    delay(300);              // wait 1/3 second
  }
}

void loop() {
  // values for acceleration and rotation:
  float xAcc, yAcc, zAcc;
  float xGyro, yGyro, zGyro;

  // check if the IMU is ready to read:
  if (IMU.accelerationAvailable() && IMU.gyroscopeAvailable()) {
    // read accelerometer and gyrometer:
    IMU.readAcceleration(xAcc, yAcc, zAcc);
    IMU.readGyroscope(xGyro, yGyro, zGyro);

    //Serial.print("sensors: ");
    if (Serial.available() > 0) {
      char input = Serial.read(); 
      if (input=='l') ledState = !ledState;
      if (input=='w') whiteLEDState = !whiteLEDState;
      if (input=='b') blueLEDState = !blueLEDState;
      Serial.print(xAcc);
      Serial.print(",");
      Serial.print(yAcc);
      Serial.print(",");
      Serial.print(zAcc);
      Serial.print(",");
      Serial.print(xGyro);
      Serial.print(",");
      Serial.print(yGyro);
      Serial.print(",");
      Serial.println(zGyro);
    }
  }
  digitalWrite(LED_BUILTIN, ledState);
  digitalWrite(whiteLED, whiteLEDState);
  digitalWrite(blueLED, blueLEDState);

  delay(10);
}